############################# Programming R #############################

################################################# set 'working Directory'
setwd("D:/AS17 translation/AS17 supplements")
opar <- par() 
#options(warn=-1)
#########################################################################
#                            Data / Sources
# infarct.csv
#########################################################################

                                                            # Section 9.1

mean(c(4,6,8,9))                   # mean function in R           

sqrt(5)                            # square root function in R                 

round(5.23454, digits=3)           # rounding to 3 decimal digits        

#########################################################################

x  <- seq(0, 2*pi, 0.01)
y1 <- sin(x)
y2 <- cos(x)

par(mfrow=c(1,1), ps=14, font=2, font.axis=2,
    font.lab=2, font.main=2, font.sub=2, bty="l")

plot(x, y1, type="l", las=1, lwd=2, 
     xlab="x radian measure", ylab="sinus / cosinus",
     xaxp=c(0,2*pi, 4), col="blue")

lines(x, y2, lwd=2, col="green")

abline(v=seq(0, 2*pi, pi/2), col="red", lty=2)


#########################################################################

library(Rcmdr)

#########################################################################


#########################################################################

                                                            # Section 9.2
                                                          
help.start()                        # help to R 

help(sqrt)                          # square root function                      

example(mean)                       # arithmetic mean          
?mean

#########################################################################

                                                            # Section 9.3
                                                          
                                    # objects in R                       
x <- 1:10; length(x); mode(x)

name <- c("statistics","mathematics"); length(name); mode(name)

#########################################################################

root.12 <- sqrt(12)                 # square root of 12                        
root.12

#########################################################################

data(Titanic)
str(Titanic)                        # data structur of object table       

#########################################################################

m <- matrix(c("a","b","c","d"), nrow=2); m     # object matrix        
is.matrix(m)
is.numeric(m)

#########################################################################

as.numeric(c("-0.1", "2.7", "B"))   # conversion of data type
as.character(5 : 10)

#########################################################################

library(date)                       # date data in R                    
x <- as.date(c("15jul2008","10mar1980")); (x[1] - x[2])/360
x1 <- mdy.date(7, 15, 2008); x2 <- mdy.date(3, 10, 1980)
str(x1); str(x2); (x1-x2)/360

#########################################################################

                                                          # Section 9.3.2
                                                
1:10                                 # generating number sequences in R 
20:15

seq(1, 5, by=0.5)

seq(1, 5, length=11)

rep(5, 20)                           # repeating values

c(1, 7:9)                            # combining values

c(1:5, 10.5, "next")

#########################################################################

data <- scan()                       # recording data from keyboard

#########################################################################

                                                          # Section 9.3.3
                                                         
                                                       
m  <- rep(1, 15); w <- rep(2, 20); sex <- c(m,w)           # factors in R
faktor <- factor(sex, labels=c("male", "female"))
summary(faktor)

#########################################################################

alter   <- rnorm(50, mean=40, sd=10); summary(alter)
alter.k <- cut(alter, breaks=c(10, 20, 30, 40, 50, 60, 70))
summary(alter.k)

#########################################################################

                                                          # Section 9.3.4
                                                         
m <- matrix(1:9, ncol=3, byrow=T); m                      # matrices in R
m[1,]
m[,2]
m[2,2]

#########################################################################

m <- rbind(m, c(10, 11, 12)); m
m <- cbind(m, c(13, 14, 15, 16)); m

#########################################################################

count <- matrix(c(12, 6, 5, 10), ncol=2, byrow=T,    # contingency table
         dimnames=list(c("row 1", "row 2"), 
                       c("column 1", "column 2"))); count

colSums(count)                                       # column sums
addmargins(count)                                    # marginal sums

#########################################################################

                                                          # Section 9.3.5
                                                         
                                              # calculating with matrices
                    
n <- 10                                 # compute variance and covariance
data <- matrix(c(11, 6,11, 9,  8, 6, 2, 7,  4, 9,10, 4,
                  6, 4, 9, 6,  5, 4, 1, 2, 10,10, 6, 9,
                  6, 8, 2, 1,  2, 2, 8, 4,  8, 2, 4,10,
                  9, 7, 6, 9), nrow=n, byrow=T,
        dimnames = list(
        c("S1","S2","S3","S4","S5","S6","S7","S8","S9","S10"),
        c("V.1", "V.2", "V.3","V.4"))); data
                                                  
one <- rep(1,10); one                             # 'one' vector
sum <- one %*% data; sum                          # over "inner product"
mean <- sum / n; mean                             # means                        
deviat <- data - one %*% mean; round(deviat,2)  # deviations from mean               
covar <- t(deviat) %*% deviat/(n - 1); round(covar,2)      # covariances                 
varia <- diag(covar); round(varia,2)              # variances 
sdi <- diag(1/sqrt(diag(covar)))                  # correlation
correl <- sdi %*% covar %*% sdi; round(correl,2)                 

                                                      
#########################################################################

                                                          # Section 9.3.6

age    <- c(19, 22, 24)                                # data in frames
gender <- c("male","female","male")
height <- c(170, 165, 181)
students  <- data.frame(age, gender, height); students                             
students[2,]
students[gender=="male",]
#########################################################################

                                                            # data import

infarct <- read.table("infarct.csv", header=T, sep=";", dec=",")
str(infarct)

edit(infarct)

#########################################################################

attach(infarct)
chol
mean(chol)

#########################################################################

  a b c d e 
1 1 2 3 4 5
2 6 7 8 9 10

x <- read.table("clipboard", header=TRUE); str(x)

#########################################################################

                                                     # variable transform
infarct <- transform(infarct, lnhbdh=log(hbdh))
infarct$lnhbdh[1:5]

#########################################################################
                                                    
replace(1:10, list=c(2, 4, 6), values=c(20, 40, 60))            # replace

#########################################################################
                                      
re.code <- function(var, old, new) {            # recode in factor levels
            x <- as.vector(var)
            i <- which(x == old); ni <- length(i)
            x <- replace(x, list=i, values=rep(new, ni))
            if (is.factor(x)) factor(x) else x }
re.code(as.factor(c("A", "A", "A", "B", "B", "C", "C")), "B", "X")

infarct <- transform(infarct,group=re.code(group, "infarct", "1"))
infarct <- transform(infarct,group=re.code(group, "control", "0"))
as.numeric(infarct$group)

#########################################################################

                                      # recode() function in library(car)
col <- c("red", "purple", "blue", "blue", "orange", "red", "orange")
library(car)
recode(col, "'red'='rot'; 'blue'='blau'; 'purple'='violett'")

#########################################################################

                                              
daten <- c(5, 9, 11, 8, 9, 3, 1, 13, 9, 12, 5, 12, 6, 3, 17, 5, 8, 7)
cutoff <- 10                                   # detection limit (cutoff)
ifelse(daten <= cutoff, daten, cutoff)

#########################################################################

infarct$age                                # categories - classification
age_class <- cut(infarct$age, breaks=c(0, 50, 70, Inf), 
                     labels=c("-50", ">50-70", ">70"))
table(age_class)

#########################################################################
                                         
c1 <- c(1,2,3,4); c2 <- c(2,5,6,7); c3 <- c(3,8,9,10)
df <- as.data.frame(rbind(c1,c2,c3))    # repeated measurements / reshape     
names(df) <- c("id","t1","t2","t3"); df                     # wide format
reshape(df, timevar="time", idvar="id", varying=list(2:4), 
        v.names="value", direction="long")                  # long format        
        
        
#########################################################################

                                                            # Section 9.4
                                                        
x <- c(1, 2, NA, 4); x                                   # missing values
y <- x + 1; y
is.na(x)
which(is.na(x))                                  # finding missing values

#########################################################################

mean(x)
mean(x, na.rm=TRUE)

#########################################################################
                                                        
any.missing.value <- function(dfr=NA)                  # NAs in dataframe
  { any(is.na(dfr)) }
age       <- c(19,   22,  24,  30,  NA,  25)
gender    <- c("male","female","male",NA,"female","male")
height    <- c(170, NA, 181, 177, 182, 196)
students  <- data.frame(age, gender, height); students
y <- students[,c("age","gender","height")]
y.na <- !apply(y, 1, any.missing.value); y[y.na,]

#########################################################################

colSums(is.na(students))

#########################################################################

na.omit(students)    # alternative - students[complete.cases(students),]

#########################################################################

                                                            # Section 9.5
                                                           
                                                          # Sort & Select
nro_1to20 <- 1:20
nro_1to20[6:10]                           # select 6th to 10th value      
blood <- c("A","B","AB","0")
blood[3]                                  # select 3rd value
attach(infarct)
infarct$chol[5]                           # select 5th rom chol in infarct    

##########################################################################

students[,3]                              # select 3rd column in dataframe
students[2,]                              # select 2nd row in dataframe

##########################################################################

nro_1to20 <- 1:20
nro_1to20[nro_1to20 > 13]

students[gender=="male",]

infarct <- read.table("infarct.csv", header=T, sep=";", dec=",")
attach(infarct)
infarct[group=="infarct" & blood_sugar>100, ]

#########################################################################

                                                             # subsetting   
subset(infarct, gender=="female" & age<45, select = c(chol, trgl))

#########################################################################

                                       # sort data, ordering  and ranking
a <- c(3, 7, 2, 8, 5, 10, 4); a
sort(a)

sort(a, decreasing=TRUE)

a <- c(3, 7, 2, 8, 5, 10, 4)
rank(a)
b <- c(3, 5, 7, 3, 6, 5)
rank(b)
rank(b, ties.method = "min")

o <- order(a); a; o; a[o]

#########################################################################

                                             
SortMat <- function(Mat, Sort)  {            # sort matrices / dataframes
        m <- do.call("order", as.data.frame(Mat[, Sort]))
        Mat[m, ]                }
SortMat(students, 3)

m <- matrix(c(2,5,4, 5,2,3, 2,6,7), byrow=T, nrow=3); m
SortMat(m, 2)

students[order(students[,3]),]

x <- c(3, 6, 4, 5, 1, 8, 7, 9)
x; x[order(x)]                                   # instead of sort(x)
x; order(order(x))                               # instead of rank(x)

#########################################################################

                                                            # Section 9.6
                                                           
                                                           # flow control
a <- rep(NA, 10); a
for (i in 1:10) if (i<6) a[i]<-"bottom" else a[i]<-"top"
a

#########################################################################
                                                          
numerator    <- c(2, 4,NA, 8, 7, 5, 3, 1)                      # ifelse()       
denominator  <- c(4, 3, 2, 1, 0, 3, 2, 0) 
quotient <- round(ifelse(denominator != 0, numerator/denominator, NA), 3)
round(quotient, 2)

#########################################################################

i <- 0; sum_over <- 0                                           # while()        
while (i < 10) {i <- i+1;  sum_over <- sum_over + i }
sum_over
sum(1:10)

#########################################################################

stdev <- function(x) {           # my own function for standard deviation
          n      <- length(x)
          s      <- sum(x)
          m      <- s / n
          saq    <- sum((x-m)^2)
          return(sqrt(saq/(n-1)))          }
x <- c (2, 3, 4, 5, 6, 7); stdev(x)                                                  
mean(x); sd(x)                                           # functions in R

#########################################################################

                                                                # apply()                      
X <- matrix(sample(1:20, 20, replace=T), ncol=4, byrow=T); X
apply(X, 1, sum)                                  # row sum               
apply(X, 2, sum)                                  # coulumn sum                
apply(X, 2, which.max)                            # max. value in column
apply(X,1, function(x) {max(x) - min(x)})         # range in row         
apply(X,1:2, function(x) sqrt(x))                 # square root   

#########################################################################

                                                                   # by()                         
infarct <- read.table("infarct.csv", header=T, sep=";", dec=",")
by(infarct[, 10:12], infarct$group, summary)

#########################################################################

                                                               # tapply()                     
x <- 1:12
g <- factor(sample(1:3, 12, replace=T)); rbind(x,g)
round(tapply(x, g, mean), 2)

infarct <- read.table("infarct.csv", header=T, sep=";", dec=",")
tapply(infarct$chol, infarct$group, mean)

#########################################################################

                                                               # sapply()                      
l <- list(height=c(160,170,177,182), weight=c(70,75,80,90,65,78))
sapply(l, mean)

#########################################################################

normal <- replicate(8, rnorm(5)); round(normal, 3)

#########################################################################

                                                            # Section 9.7
                                                            
                                                 # mathematical functions
vect <- c(1.42, 4.84, -2.55, - 1.24)
abs(vect)
round(vect, digits=1)
ceiling(vect)
floor(vect)
trunc(vect)
round(vect, digits=1)
max(vect)
min(vect)
exp(5)
round(sin(seq(0, 2*pi, by=(pi/4))), digits=3)
sqrt(7)

#########################################################################

                                                 # frequencies and tables
infarct <- read.table("infarct.csv", header=T, sep=";", dec=",")
table(infarct$group, infarct$gender)
tab <- as.data.frame(table(infarct$group, infarct$gender))
names(tab) <- c("Group","Gender","Frequency"); tab

#########################################################################

                                                  # statistical functions
infarct <- read.csv("infarct.CSV", sep=";",dec=",")
attach(infarct)
mean(age)
sd(age)
max(blood_sugar)
quantile(rr_syst, prob=c(0.10,0.25,0.50,0.75,0.90))
summary(chol)

#########################################################################

                                                            # aggregate()
infarct <- read.table("infarct.csv", header=T, sep=";", dec=",")
attach(infarct)   
stat <- aggregate(chol, by=data.frame(gender), summary, na.rm=T)
stat                                             
stat[[2]][,3]                            # partial results - median value

#########################################################################

                                                            # Section 9.8
                                                            
                                                    # graphical functions
infarct <- read.csv("infarct.CSV", sep=";",dec=",")
attach(infarct)
                                                             # figure 9.6
par(mfrow=c(1,3), ps=15, font=2, font.axis=2, font.lab=2, 
    font.main=2, font.sub=2, lwd=2)
    hist(chol, main="histogram", col="grey", las=1)
boxplot(blood_sugar[group=="infarct"], blood_sugar[group=="control"], 
            xlab="Group", main="Box-Whisker plot", las=1)
plot(rr_syst, rr_diat, main="Scatterplot")

#########################################################################

                                                             # figure 9.7
par(mfrow=c(1,2), lwd=2, font.axis=2, bty="l", ps=14)
 
Pex <- 2.0
ipch <- 1:20
k <- floor(sqrt(20))
dd <- c(-1, 1)/2
rx <- dd + range(ix <- (ipch - 1)%/%k)
ry <- dd + range(iy <- 3 + (k - 1) - (ipch - 1)%%k)
pch <- as.list(ipch)
plot(rx, ry, type = "n", axes = FALSE, xlab = "", ylab = "", 
     main = "symbols (pch)")
# abline(v = ix, h = iy, col = "lightgray", lty = "dotted")
for (i in 1:20) {
    pc <- pch[[i]]
    points(ix[i], iy[i], pch = pc, col = "black", bg = "yellow", cex = Pex)
    text(ix[i] - 0.5, iy[i], pc, col = "black", font=3, cex = 1.0)
}

Pex <- 3
ity <- 7
dd <- c(-1, 1)/2
rx <- dd + range(ix <- rep(c(1,2), 7))
ry <- dd + range(iy <- seq(1, 7, by=1))
plot(rx, ry, type = "n", axes = FALSE, xlab = "", ylab = "", 
     main = "lines (lty)")
for (i in 1:7) {
    pc <- i
    lines(c(ix[i], ix[i+1]), c(iy[i], iy[i]), lty=i, lwd=2, cex = Pex)
    text(1 - 0.2, iy[i], pc, col = "black", font=3, cex = 1.0)
}

###########################################################################

                                                            # figure 9.8
par(mfrow=c(1,1),ps=14, font=2, font.axis=2, font.lab=2, 
                                   font.main=2, font.sub=2, lwd=2)
                                   
x <- seq(-4, +4, by=0.2)
y <- x^2
plot(x, y, type="l", las=1)
abline(v=0)
polygon(x[10:30], y[10:30], density=10)
text(2.5,1, "segment")
title("parabola")
############################################################################
